%% gaussian_sum.m 

%% Function to compute an affine combination of "n" Gaussian type-1 
%% sets as described in Example 7-4  in the book Uncertain Rule-Based 
%% Fuzzy Logic Systems: Introduction and New Directions, by Jerry M. 
%% Mendel, and published by Prentice-Hall, 2000.

%% Written by Nilesh N. Karnik - July 23,1998
%% For use with MATLAB 5.1 or higher.

%%  "sum_{i=1}^n alpha_i F_i + beta"

%% Outputs : "m_sum" and "s_sum" (scalars) are, respectively, the 
%% mean and standard deviation of the result of the sum. 

%% Inputs : "m" and "sigma" are both n-vectors, containing the means and 
%% standard deviations of the "n" Gaussians. All the standard deviations 
%% should be positive. "alpha" is an n-vector containing the coefficients 
%% of the "n" Gaussians in the affine combination (see Theorem 2.5), and 
%% "beta" (scalar) is a crisp constant that is added to the Gaussians.
%% If "tnorm < 0" (scalar), minimum t-norm is used, else product is used.


function[m_sum,s_sum] = gaussian_sum(m,sigma,alpha,beta,tnorm)

m_sum = sum(alpha .* m) + beta ;

if tnorm < 0,
   s_sum = sum(abs(alpha .* sigma)) ;
else
   s_sum = sqrt(sum((alpha .* sigma).^2)) ;
end   % if tnorm


return ;
